/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.proxy.http2;

import com.xk72.proxy.http.HttpFields;
import com.xk72.proxy.io.Bvcn;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Http2Fields
extends HttpFields
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String GSXJ = "://";
    private static String InuZ = ":status";
    private static String Gwbn = ":method";
    private static String Wczh = ":scheme";
    private static String KRBh = ":authority";
    private static String VdwQ = ":path";
    private static final String hndF = "; ";
    protected Set<String> sensitiveFields = new HashSet<String>();
    private boolean pushPromise = false;
    private transient boolean eOaK = false;

    public static boolean FwRs(String string) {
        return ":status".equals(string) || ":method".equals(string) || ":scheme".equals(string) || ":authority".equals(string) || ":path".equals(string);
    }

    @Override
    public void addField(String string, String string2) {
        super.addField(string.toLowerCase(), string2);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public Http2Fields clone() {
        Http2Fields http2Fields = new Http2Fields();
        new Http2Fields().pushPromise = this.pushPromise;
        http2Fields.fieldNames = new ArrayList(this.fieldNames);
        http2Fields.fieldValues = new ArrayList(this.fieldValues);
        http2Fields.sensitiveFields = new HashSet<String>(this.sensitiveFields);
        return http2Fields;
    }

    public void setPushPromise(boolean bl) {
        this.pushPromise = bl;
    }

    public boolean isPushPromise() {
        return this.pushPromise;
    }

    public void setStatus(int n) {
        if (n < 0) {
            this.removeField(":status");
            return;
        }
        this.setField(":status", String.valueOf(n));
    }

    public void setMethod(String string) {
        this.FwRs(":method", string);
    }

    public void setScheme(String string) {
        this.FwRs(":scheme", string);
    }

    public void setAuthority(String string) {
        this.FwRs(":authority", string);
    }

    @Override
    public String getHost() {
        return this.getField(":authority");
    }

    @Override
    public void setHost(String string) {
        this.setAuthority(string);
    }

    @Override
    public String getCookies() {
        String[] stringArray = this.getFieldValues("Cookie");
        if (stringArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : stringArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(hndF);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public void setCookies(String stringArray) {
        this.removeField("Cookie");
        if (stringArray != null) {
            for (String string : stringArray.split(";")) {
                this.addField("Cookie".toLowerCase(), string.trim());
            }
        }
    }

    public void setPath(String string) {
        this.FwRs(":path", string);
    }

    private void FwRs(String string, String string2) {
        if (string2 == null) {
            this.removeField(string);
            return;
        }
        this.setField(string, string2);
    }

    @Override
    public String getFirstLine() {
        int n = this.getResponseStatus();
        if (n >= 0) {
            return "HTTP/2.0 " + n;
        }
        String string = this.getField(":method");
        if (string == null) {
            return null;
        }
        Http2Fields http2Fields = this;
        return string + " " + http2Fields.FwRs(http2Fields.eOaK) + " HTTP/2.0";
    }

    public String getDisplayString() {
        int n = this.getResponseStatus();
        if (n >= 0) {
            return "HTTP/2.0 " + n;
        }
        String string = this.getField(":method");
        if (string == null) {
            return "<empty>";
        }
        return string + " " + this.getRequestString() + " HTTP/2.0";
    }

    @Override
    public void setFirstLine(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRequestMethod() {
        return this.getField(":method");
    }

    @Override
    public String getRequestString() {
        return this.FwRs(true);
    }

    private String FwRs(boolean bl) {
        String string = this.getField(":scheme");
        String string2 = this.getField(":authority");
        String string3 = this.getField(":path");
        if (string2 == null || "*".equals(string3)) {
            return string3;
        }
        if (string == null && string3 == null) {
            return string2;
        }
        if (bl) {
            return string + GSXJ + string2 + string3;
        }
        return string3;
    }

    @Override
    public String getRequestProtocolVersion() {
        return "HTTP/2.0";
    }

    @Override
    public String getResponseProtocolVersion() {
        return "HTTP/2.0";
    }

    @Override
    public int getResponseStatus() {
        String string = this.getField(":status");
        if (string == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public String getResponseStatusDescription() {
        return null;
    }

    @Override
    public void setResponseStatus(String string, int n, String string2) {
        this.setStatus(n);
    }

    @Override
    public void setConnect(String string, int n, String string2) {
        this.setMethod("CONNECT");
        this.setAuthority(string + ":" + (n < 0 ? 443 : n));
        this.setScheme(null);
        this.setPath(null);
    }

    @Override
    public void setRequestFields(String string, String string2, String string3, int n, String string4, String string5, boolean bl) {
        this.eOaK = bl;
        this.setMethod(string);
        this.setScheme(string2);
        this.setPath(string4);
        if (bl) {
            this.setAuthority(string3 + (String)(n < 0 ? "" : ":" + n));
        }
    }

    @Override
    public double getHttpVersion() {
        return 2.0;
    }

    public void addField(String string, String string2, boolean bl) {
        super.addField(string, string2);
        if (bl) {
            string = Http2Fields.GSXJ(string, string2);
            this.sensitiveFields.add(string);
        }
    }

    public boolean isSensitive(String string, String string2) {
        return this.sensitiveFields.contains(Http2Fields.GSXJ(string, string2));
    }

    private static String GSXJ(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        if (string.equalsIgnoreCase("Cookie")) {
            int n = string2.indexOf(61);
            string2 = n < 0 ? string2 : string2.substring(0, n);
            return string + ":" + string2.trim();
        }
        return string;
    }

    @Override
    public boolean isEmpty() {
        return this.fieldNames.isEmpty() && this.fieldValues.isEmpty();
    }

    @Override
    protected void writeFirstLine(ByteArrayOutputStream byteArrayOutputStream) {
    }

    @Override
    protected boolean readFirstLine(Bvcn bvcn, boolean bl) {
        return true;
    }
}

