/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.tools.rewrite;

import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.lib.UIUtils;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.tools.rewrite.AlzL;
import com.xk72.charles.tools.rewrite.JqXM;
import com.xk72.charles.tools.rewrite.RewriteRule;
import com.xk72.charles.tools.rewrite.fGuk;
import com.xk72.charles.tools.rewrite.jSAY;
import com.xk72.charles.tools.rewrite.nnsC;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

class RewriteRulePanel
extends SettingsPanel {
    private final JCheckBox whereRequest;
    private final JCheckBox whereResponse;
    private final JRadioButton replaceFirst;
    private final JRadioButton replaceAll;
    private final JCheckBox regexHeader;
    private final JCheckBox regexValue;
    private final JCheckBox matchWholeValue;
    private final JCheckBox caseSensitive;
    private final JTextField matchHeader;
    private final JTextField matchValue;
    private final JTextField newHeader;
    private final JTextField newValue;
    private final JComboBox<String> ruleType;
    private RewriteRule rule;
    private final JTextArea matchHelp;

    public RewriteRulePanel() {
        super("Rewrite Action");
        Object object;
        RewriteRulePanel rewriteRulePanel = this;
        rewriteRulePanel.setHelp(rewriteRulePanel.ctx.getBundle().getString("tools.Rewrite.editor.help"));
        this.ruleType = new JComboBox();
        String[] stringArray = RewriteRule.getRuleTypeNames();
        Object object2 = stringArray;
        object2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            object = object2[i];
            this.ruleType.addItem((String)object);
        }
        this.whereRequest = new JCheckBox("Request");
        this.whereResponse = new JCheckBox("Response");
        object2 = new JLabel("Name:");
        this.matchHeader = new JTextField();
        this.matchValue = new JTextField();
        this.regexHeader = new JCheckBox("Regex");
        this.regexValue = new JCheckBox("Regex");
        this.matchWholeValue = new JCheckBox("Match whole value");
        this.caseSensitive = new JCheckBox("Case sensitive");
        this.matchHelp = FormUtils.KRBh("");
        this.matchHelp.setForeground(Color.red);
        this.matchHelp.setVisible(false);
        JLabel jLabel = new JLabel("Name:");
        this.newHeader = new JTextField();
        this.newValue = new JTextField();
        Serializable serializable = new ButtonGroup();
        this.replaceFirst = new JRadioButton("Replace first");
        this.replaceAll = new JRadioButton("Replace all");
        ((ButtonGroup)serializable).add(this.replaceFirst);
        ((ButtonGroup)serializable).add(this.replaceAll);
        this.replaceAll.setSelected(true);
        this.matchHeader.getDocument().addDocumentListener(new jSAY(this));
        this.matchValue.getDocument().addDocumentListener(new fGuk(this));
        this.regexHeader.addItemListener(new nnsC(this));
        this.regexValue.addItemListener(new JqXM(this));
        object = new JPanel(FormUtils.eOaK());
        ((Container)object).add((Component)new JLabel("Type:"), "label");
        ((Container)object).add(this.ruleType);
        serializable = new JPanel((LayoutManager)new MigLayout("fill, ins " + UIUtils.FwRs()));
        String string = "Where";
        JPanel jPanel = serializable;
        UIUtils.FwRs((JPanel)serializable, string);
        ((Container)serializable).add(this.whereRequest);
        ((Container)serializable).add(this.whereResponse);
        ((Container)object).add((Component)serializable, "span,grow");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("wrap,fill,ins " + UIUtils.FwRs() + ", hidemode 3", "[label][fill,grow][pref:pref]"));
        string = "Match";
        jPanel = jPanel2;
        UIUtils.FwRs(jPanel2, string);
        jPanel2.add((Component)FormUtils.InuZ("Enter text to match or leave blank to match all."), "left,span,grow");
        jPanel2.add((Component)object2);
        jPanel2.add(this.matchHeader);
        jPanel2.add(this.regexHeader);
        jPanel2.add(new JLabel("Value:"));
        jPanel2.add(this.matchValue);
        jPanel2.add(this.regexValue);
        jPanel2.add((Component)this.matchWholeValue, "skip 1,split 2,span");
        jPanel2.add(this.caseSensitive);
        jPanel2.add((Component)this.matchHelp, "left,span,grow");
        ((Container)object).add((Component)jPanel2, "span,grow");
        JPanel jPanel3 = new JPanel(FormUtils.VdwQ("ins " + UIUtils.FwRs()));
        string = "Replace";
        jPanel = jPanel3;
        UIUtils.FwRs(jPanel3, string);
        jPanel3.add(jLabel);
        jPanel3.add(this.newHeader);
        jPanel3.add(new JLabel("Value:"));
        jPanel3.add(this.newValue);
        jPanel3.add((Component)this.replaceFirst, "skip 1,split 2,span");
        jPanel3.add(this.replaceAll);
        jPanel3.add((Component)FormUtils.InuZ("Enter new values or leave blank for no change. If using regex matches you may enter references to groups, eg. $1"), "left,span,grow");
        ((Container)object).add((Component)jPanel3, "span,grow");
        this.add((Component)object);
        this.ruleType.addItemListener(new AlzL(this, (JPanel)serializable, jPanel2, jPanel3, (JLabel)object2, jLabel));
    }

    private void FwRs() {
        if (this.regexHeader.isSelected()) {
            try {
                Pattern.compile(this.matchHeader.getText());
                this.FwRs(null);
                return;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.FwRs(patternSyntaxException.getMessage());
                return;
            }
        }
        this.FwRs(null);
    }

    private void GSXJ() {
        if (this.regexValue.isSelected()) {
            try {
                Pattern.compile(this.matchValue.getText());
                this.FwRs(null);
                return;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.FwRs(patternSyntaxException.getMessage());
                return;
            }
        }
        this.FwRs(null);
    }

    private void FwRs(String object) {
        boolean bl = this.matchHelp.isVisible();
        boolean bl2 = object != null;
        this.matchHelp.setText((String)object);
        this.matchHelp.setVisible(bl2);
        if ((bl || bl2) && (object = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this.matchHelp)) != null) {
            Dimension dimension = ((Container)object).getPreferredSize();
            ((Container)object).getPreferredSize().width = Math.max(dimension.width, ((Component)object).getWidth());
            ((Component)object).setPreferredSize(dimension);
            ((Window)object).pack();
            ((Component)object).setPreferredSize(null);
        }
    }

    @Override
    public boolean preSave() {
        if (RewriteRule.ruleNameToType((String)this.ruleType.getSelectedItem()) == -1) {
            throw new SettingsException("Type", "Please choose the rule type");
        }
        if (this.regexHeader.isSelected()) {
            try {
                Pattern.compile(this.matchHeader.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SettingsException("Match Header", "Invalid regular expression");
            }
        }
        if (this.regexValue.isSelected()) {
            try {
                Pattern.compile(this.matchValue.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SettingsException("Match Value", "Invalid regular expression");
            }
        }
        return super.preSave();
    }

    @Override
    public boolean save() {
        this.rule.setRuleType(RewriteRule.ruleNameToType((String)this.ruleType.getSelectedItem()));
        this.rule.setMatchRequest(this.whereRequest.isEnabled() && this.whereRequest.isSelected());
        this.rule.setMatchResponse(this.whereResponse.isEnabled() && this.whereResponse.isSelected());
        this.rule.setMatchHeader(this.matchHeader.isEnabled() ? this.matchHeader.getText() : null);
        this.rule.setMatchValue(this.matchValue.isEnabled() ? this.matchValue.getText() : null);
        this.rule.setNewHeader(this.newHeader.isEnabled() ? this.newHeader.getText() : null);
        this.rule.setNewValue(this.newValue.isEnabled() ? this.newValue.getText() : null);
        this.rule.setMatchHeaderRegex(this.regexHeader.isEnabled() && this.regexHeader.isSelected());
        this.rule.setMatchValueRegex(this.regexValue.isEnabled() && this.regexValue.isSelected());
        this.rule.setMatchWholeValue(this.matchWholeValue.isEnabled() && this.matchWholeValue.isSelected());
        this.rule.setCaseSensitive(this.caseSensitive.isEnabled() && this.caseSensitive.isSelected());
        int n = this.replaceFirst.isEnabled() && this.replaceFirst.isSelected() ? 1 : 2;
        this.rule.setReplaceType(n);
        return true;
    }

    public void setRule(RewriteRule rewriteRule) {
        this.rule = rewriteRule;
        this.ruleType.setSelectedItem(RewriteRule.ruleTypeToName(rewriteRule.getRuleType()));
        this.whereRequest.setSelected(rewriteRule.isMatchRequest());
        this.whereResponse.setSelected(rewriteRule.isMatchResponse());
        this.matchHeader.setText(rewriteRule.getMatchHeader());
        this.matchValue.setText(rewriteRule.getMatchValue());
        this.newHeader.setText(rewriteRule.getNewHeader());
        this.newValue.setText(rewriteRule.getNewValue());
        this.regexHeader.setSelected(rewriteRule.isMatchHeaderRegex());
        this.regexValue.setSelected(rewriteRule.isMatchValueRegex());
        this.matchWholeValue.setSelected(rewriteRule.isMatchWholeValue());
        this.caseSensitive.setSelected(rewriteRule.isCaseSensitive());
        this.replaceAll.setSelected(rewriteRule.getReplaceType() == 2);
        this.replaceFirst.setSelected(rewriteRule.getReplaceType() == 1);
    }

    public RewriteRule getRule() {
        return this.rule;
    }

    private void FwRs(JPanel componentArray, boolean bl) {
        componentArray.setEnabled(bl);
        Component[] componentArray2 = componentArray.getComponents();
        componentArray = componentArray2;
        componentArray = componentArray2;
        int n = componentArray2.length;
        for (int i = 0; i < n; ++i) {
            Component component = componentArray[i];
            component.setEnabled(bl);
            if (!(component instanceof JPanel)) continue;
            this.FwRs((JPanel)component, bl);
        }
    }

    static /* synthetic */ void FwRs(RewriteRulePanel rewriteRulePanel) {
        if (rewriteRulePanel.regexHeader.isSelected()) {
            try {
                Pattern.compile(rewriteRulePanel.matchHeader.getText());
                rewriteRulePanel.FwRs(null);
                return;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                rewriteRulePanel.FwRs(patternSyntaxException.getMessage());
                return;
            }
        }
        rewriteRulePanel.FwRs(null);
    }

    static /* synthetic */ void GSXJ(RewriteRulePanel rewriteRulePanel) {
        if (rewriteRulePanel.regexValue.isSelected()) {
            try {
                Pattern.compile(rewriteRulePanel.matchValue.getText());
                rewriteRulePanel.FwRs(null);
                return;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                rewriteRulePanel.FwRs(patternSyntaxException.getMessage());
                return;
            }
        }
        rewriteRulePanel.FwRs(null);
    }

    static /* synthetic */ void FwRs(RewriteRulePanel rewriteRulePanel, JPanel jPanel, boolean bl) {
        rewriteRulePanel.FwRs(jPanel, bl);
    }

    static /* synthetic */ JTextField InuZ(RewriteRulePanel rewriteRulePanel) {
        return rewriteRulePanel.matchHeader;
    }

    static /* synthetic */ JCheckBox Gwbn(RewriteRulePanel rewriteRulePanel) {
        return rewriteRulePanel.regexHeader;
    }

    static /* synthetic */ JTextField Wczh(RewriteRulePanel rewriteRulePanel) {
        return rewriteRulePanel.newHeader;
    }
}

