/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.lib;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.xk72.charles.lib.IPRange$IPRangeFormatException;
import com.xk72.proxy.wmIx.dqaG;
import com.xk72.util.JqXM;
import com.xk72.util.oVPf;
import com.xk72.util.ojsH;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.StringTokenizer;

@XStreamAlias(value="ipRange")
@ojsH
@oVPf
public class IPRange
implements JqXM {
    private int[] ip;
    private int[] mask;
    private static final String SIXTEEN_ZEROS = ":0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:";

    public IPRange() {
    }

    public IPRange(String string) {
        Object object = new StringTokenizer(string, "/");
        int n = ((StringTokenizer)object).countTokens();
        int[] nArray = IPRange.ipToBytes(((StringTokenizer)object).nextToken());
        if (nArray == null) {
            throw new IPRange$IPRangeFormatException(string);
        }
        object = n == 2 ? (Object)IPRange.maskToBytes(nArray.length, ((StringTokenizer)object).nextToken()) : (Object)IPRange.maskToBytes(nArray.length, String.valueOf(nArray.length << 3));
        if (object == null) {
            throw new IPRange$IPRangeFormatException(string);
        }
        this.setIp(nArray);
        this.setMask((int[])object);
    }

    public static IPRange parseRange(String string) {
        return new IPRange(string);
    }

    @Override
    public IPRange clone() {
        try {
            IPRange iPRange = (IPRange)super.clone();
            iPRange.setIp(Arrays.copyOf(this.ip, this.ip.length));
            iPRange.setMask(Arrays.copyOf(this.mask, this.mask.length));
            return iPRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean match(InetAddress object) {
        byte[] byArray = ((InetAddress)object).getAddress();
        object = byArray;
        if (byArray.length != this.ip.length) {
            return false;
        }
        for (int i = 0; i < ((Object)object).length; ++i) {
            if ((this.ip[i] & this.mask[i]) == (object[i] & this.mask[i])) continue;
            return false;
        }
        return true;
    }

    private static int[] ipToBytes(String string) {
        if (string.indexOf(58) < 0) {
            return IPRange.ipv4ToBytes(string);
        }
        return IPRange.ipv6ToBytes(string);
    }

    private static int[] ipv4ToBytes(String object) {
        if (((StringTokenizer)(object = new StringTokenizer((String)object, "."))).countTokens() != 4) {
            return null;
        }
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = Integer.parseInt(((StringTokenizer)object).nextToken());
            if (nArray[i] <= 255) continue;
            return null;
        }
        return nArray;
    }

    private static int[] ipv6ToBytes(String object) {
        byte[] byArray = dqaG.Wczh((String)object);
        object = byArray;
        if (byArray == null) {
            return null;
        }
        int n = 0;
        int[] nArray = new int[16];
        for (Object object2 : object) {
            nArray[n++] = object2 & 0xFF;
        }
        return nArray;
    }

    private static int maskBytesToMask(int[] nArray) {
        int n = 0;
        boolean bl = false;
        for (int n2 : nArray) {
            for (int i = 0; i < 8; ++i) {
                if ((n2 & 0x80) == 0) {
                    bl = true;
                } else {
                    if (bl) {
                        return -1;
                    }
                    ++n;
                }
                n2 <<= 1;
            }
        }
        return n;
    }

    private static int[] maskToBytes(int n, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = stringTokenizer.countTokens();
        if (n2 == n) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
            }
            return nArray;
        }
        if (n2 == 1) {
            int[] nArray = new int[n];
            int n3 = Integer.parseInt(string);
            for (int i = 0; i < n && n3 > 0; n3 -= 8, ++i) {
                nArray[i] = n3 >= 8 ? 255 : (int)(256.0 - Math.pow(2.0, 8 - n3));
            }
            if (n3 > 0) {
                return null;
            }
            return nArray;
        }
        return null;
    }

    public void setIp(int[] nArray) {
        this.ip = nArray;
    }

    public void setMask(int[] nArray) {
        this.mask = nArray;
    }

    public int[] getIp() {
        return this.ip;
    }

    public int[] getMask() {
        return this.mask;
    }

    public String toString() {
        if (this.ip != null && this.mask != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.ip.length == 16) {
                this.ipv6toString(stringBuffer);
            } else {
                this.ipv4toString(stringBuffer);
            }
            int n = IPRange.maskBytesToMask(this.mask);
            if (n != -1) {
                if (n != this.ip.length << 3) {
                    stringBuffer.append('/');
                    stringBuffer.append(n);
                }
            } else {
                stringBuffer.append('/');
                for (n = 0; n < this.mask.length; ++n) {
                    stringBuffer.append(this.mask[n]);
                    if (n >= this.mask.length - 1) continue;
                    stringBuffer.append('.');
                }
            }
            return stringBuffer.toString();
        }
        return "0.0.0.0/0";
    }

    private void ipv4toString(StringBuffer stringBuffer) {
        for (int i = 0; i < this.ip.length; ++i) {
            stringBuffer.append(this.ip[i]);
            if (i >= this.ip.length - 1) continue;
            stringBuffer.append('.');
        }
    }

    private void ipv6toString(StringBuffer stringBuffer) {
        int n = 0;
        while (n < this.ip.length) {
            stringBuffer.append(":");
            stringBuffer.append(Integer.toHexString(this.ip[n++] << 8 & 0xFF00 | this.ip[n++] & 0xFF));
        }
        stringBuffer.append(":");
        for (n = 16; n > 1; --n) {
            int n2 = (n << 1) + 1;
            String string = SIXTEEN_ZEROS.substring(0, n2);
            int n3 = stringBuffer.indexOf(string);
            if (n3 < 0) continue;
            int n4 = n3;
            stringBuffer.replace(n4, n4 + n2, "::");
            break;
        }
        if (stringBuffer.charAt(0) == ':' && stringBuffer.charAt(1) != ':') {
            stringBuffer.deleteCharAt(0);
        }
        StringBuffer stringBuffer2 = stringBuffer;
        if (stringBuffer2.charAt(stringBuffer2.length() - 1) == ':') {
            StringBuffer stringBuffer3 = stringBuffer;
            if (stringBuffer3.charAt(stringBuffer3.length() - 2) != ':') {
                StringBuffer stringBuffer4 = stringBuffer;
                stringBuffer4.deleteCharAt(stringBuffer4.length() - 1);
            }
        }
    }
}

