/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.transaction.chart;

import com.xk72.charles.gui.transaction.chart.AbstractChartTableModel;
import com.xk72.charles.gui.transaction.chart.ChartFlowTableModel$FlowType;
import com.xk72.charles.gui.transaction.chart.criY;
import com.xk72.charles.gui.transaction.chart.jSAY;
import com.xk72.charles.model.Flow;
import com.xk72.charles.model.Transaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChartFlowTableModel
extends AbstractChartTableModel {
    private static final int FwRs = 1024;
    private jSAY flowInfo = new jSAY(this);
    private boolean active;
    private long start;
    private long end;
    private ArrayList<criY> buckets = new ArrayList();
    private final StringBuilder buf = new StringBuilder();
    private static final String[] GSXJ = new String[]{"#", "Resource", "Activity"};
    private static final Class<?>[] InuZ = new Class[]{Integer.class, Transaction.class, jSAY.class};

    public ChartFlowTableModel() {
        super(GSXJ, InuZ, 1);
    }

    @Override
    protected void update() {
        int n = this.transactions.size();
        this.start = Long.MAX_VALUE;
        this.end = 0L;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Transaction transaction = (Transaction)this.transactions.get(i);
            if (transaction.getEndTime() == null) {
                bl = true;
            } else if (transaction.getEndTime().getTime() > this.end) {
                this.end = transaction.getEndTime().getTime();
            }
            if (transaction.getStartTime().getTime() < this.start) {
                this.start = transaction.getStartTime().getTime();
            }
            int n2 = this.buckets.size();
            this.buckets.clear();
            this.FwRs(transaction, ChartFlowTableModel$FlowType.FwRs, transaction.getRequestFlow());
            this.FwRs(transaction, ChartFlowTableModel$FlowType.GSXJ, transaction.getResponseFlow());
            if (n2 <= 1024 && this.buckets.size() <= 1024) continue;
            this.buckets.trimToSize();
        }
        if (bl) {
            this.active = true;
            this.end = System.currentTimeMillis();
        } else {
            this.active = false;
        }
        Collections.sort(this.buckets);
    }

    private void FwRs(Transaction transaction, ChartFlowTableModel$FlowType chartFlowTableModel$FlowType, Flow object) {
        for (com.xk72.charles.model.criY criY2 : ((Flow)object).getData()) {
            this.buckets.add(new criY(transaction, chartFlowTableModel$FlowType, criY2.FwRs, criY2.GSXJ, criY2.InuZ));
        }
    }

    @Override
    public int getRowCount() {
        return this.buckets.size() + this.footerRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        if (n < 0) {
            return null;
        }
        List list = this.transactions;
        synchronized (list) {
            if (n < this.buckets.size()) {
                switch (n2) {
                    case 0: {
                        return n + 1;
                    }
                    case 1: {
                        return this.buckets.get((int)n).FwRs;
                    }
                    case 2: {
                        this.flowInfo.FwRs(this.buckets.get(n));
                        return this.flowInfo;
                    }
                }
                return null;
            }
            return this.getFooterValueAt(n - this.transactions.size(), n2);
        }
    }

    @Override
    protected Object getFooterValueAt(int n, int n2) {
        switch (n2) {
            case 1: {
                return "Total Duration";
            }
            case 2: {
                if (this.transactions.size() > 0) {
                    this.buf.setLength(0);
                    this.formatter.FwRs(this.buf, this.end - this.start);
                    if (this.active) {
                        this.buf.append("\u2026");
                    }
                    return this.buf.toString();
                }
                return null;
            }
        }
        return null;
    }

    static /* synthetic */ long FwRs(ChartFlowTableModel chartFlowTableModel) {
        return chartFlowTableModel.start;
    }

    static /* synthetic */ long GSXJ(ChartFlowTableModel chartFlowTableModel) {
        return chartFlowTableModel.end;
    }
}

