/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.UserInterfaceConfiguration;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.gui.settings.YyWX;
import com.xk72.charles.macos.nnsC;
import com.xk72.charles.win32.dqaG;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.SystemTray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UISettingsPanel
extends SettingsPanel {
    private final JComboBox<Comparable<?>> cFont;
    private final JComboBox<Comparable<?>> cFontSize;
    private final JCheckBox bShowTrayIcon = new JCheckBox(nnsC.FwRs() ? "Show Charles icon in the menu bar" : "Show system tray icon");
    private final JCheckBox bMinimiseToTray = new JCheckBox("Minimise to system tray");
    private final JCheckBox bShowMemoryUsage = new JCheckBox("Show memory usage");
    private final JCheckBox bEnableHotkeys = new JCheckBox("Enable global hotkeys");
    private final JCheckBox bAlwaysOnTop = new JCheckBox("Charles window always on top");
    private final JCheckBox bHighlightTreeChanges = new JCheckBox("Highlight changes in the Structure view");

    public UISettingsPanel() {
        super(CharlesContext.getInstance().getBundle().getString("settings.ui.name"));
        UISettingsPanel uISettingsPanel = this;
        uISettingsPanel.setHelp(uISettingsPanel.ctx.getBundle().getString("settings.ui.help"));
        UserInterfaceConfiguration userInterfaceConfiguration = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        String[] stringArray = UISettingsPanel.FwRs(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.cFont = new JComboBox<String>(stringArray);
        this.cFont.insertItemAt((Comparable<?>)((Object)"Default"), 0);
        this.cFont.setSelectedIndex(0);
        if (userInterfaceConfiguration.getDisplayFont() != null) {
            this.cFont.setSelectedItem(userInterfaceConfiguration.getDisplayFont());
        }
        this.cFontSize = new JComboBox();
        this.cFontSize.addItem((Comparable<?>)((Object)"Default"));
        for (int i = 9; i <= 24; ++i) {
            this.cFontSize.addItem(Integer.valueOf(i));
        }
        if (userInterfaceConfiguration.getDisplayFontSize() != null) {
            this.cFontSize.setSelectedItem(userInterfaceConfiguration.getDisplayFontSize());
        }
        this.bShowTrayIcon.setSelected(userInterfaceConfiguration.isShowTrayIcon());
        this.bMinimiseToTray.setSelected(userInterfaceConfiguration.isMinimiseToTray());
        this.bMinimiseToTray.setEnabled(this.bShowTrayIcon.isSelected());
        this.bShowTrayIcon.addChangeListener(new YyWX(this));
        this.bShowMemoryUsage.setSelected(userInterfaceConfiguration.isShowMemoryUsage());
        this.bEnableHotkeys.setSelected(userInterfaceConfiguration.isEnableHotkeys());
        this.bAlwaysOnTop.setSelected(userInterfaceConfiguration.isAlwaysOnTop());
        this.bHighlightTreeChanges.setSelected(userInterfaceConfiguration.isHighlightTreeChanges());
        JPanel jPanel = new JPanel(FormUtils.eOaK());
        jPanel.add(new JLabel("Display font:"));
        jPanel.add(this.cFont);
        jPanel.add(new JLabel("Display font size:"));
        jPanel.add(this.cFontSize);
        FormUtils.FwRs(jPanel);
        if (SystemTray.isSupported()) {
            jPanel.add((Component)this.bShowTrayIcon, "skip");
        }
        if (dqaG.FwRs()) {
            jPanel.add((Component)this.bMinimiseToTray, "skip");
            jPanel.add((Component)this.bEnableHotkeys, "skip");
        }
        if (CharlesContext.getJavaVersion() >= 15) {
            jPanel.add((Component)this.bAlwaysOnTop, "skip");
        }
        jPanel.add((Component)this.bHighlightTreeChanges, "skip");
        jPanel.add((Component)this.bShowMemoryUsage, "skip");
        this.add(jPanel);
    }

    private static String[] FwRs(String[] object) {
        object = new ArrayList<String>(Arrays.asList(object));
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(".System")) continue;
            iterator.remove();
        }
        Object object2 = object;
        return object2.toArray(new String[object2.size()]);
    }

    public static void main(String[] stringArray) {
        new UISettingsPanel().test();
    }

    @Override
    public boolean save() {
        UserInterfaceConfiguration userInterfaceConfiguration = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        String string = this.cFont.getSelectedItem().toString();
        Integer n = this.cFontSize.getSelectedItem() instanceof Integer ? (Integer)this.cFontSize.getSelectedItem() : null;
        boolean bl = !UISettingsPanel.FwRs(userInterfaceConfiguration.getDisplayFont(), string) || !UISettingsPanel.FwRs(userInterfaceConfiguration.getDisplayFontSize(), n);
        userInterfaceConfiguration.setDisplayFont(string);
        userInterfaceConfiguration.setDisplayFontSize(n);
        if (bl) {
            this.ctx.info("Display Font Changes", "Please restart Charles to complete the application of display font changes.");
        }
        userInterfaceConfiguration.setShowTrayIcon(this.bShowTrayIcon.isSelected());
        userInterfaceConfiguration.setMinimiseToTray(this.bMinimiseToTray.isSelected());
        userInterfaceConfiguration.setShowMemoryUsage(this.bShowMemoryUsage.isSelected());
        userInterfaceConfiguration.setEnableHotkeys(this.bEnableHotkeys.isSelected());
        userInterfaceConfiguration.setAlwaysOnTop(this.bAlwaysOnTop.isSelected());
        userInterfaceConfiguration.setHighlightTreeChanges(this.bHighlightTreeChanges.isSelected());
        return true;
    }

    private static boolean FwRs(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    static /* synthetic */ JCheckBox FwRs(UISettingsPanel uISettingsPanel) {
        return uISettingsPanel.bShowTrayIcon;
    }

    static /* synthetic */ JCheckBox GSXJ(UISettingsPanel uISettingsPanel) {
        return uISettingsPanel.bMinimiseToTray;
    }
}

