/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.LocationPatternConfiguration;
import com.xk72.charles.config.ProxyConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJPanel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.lib.LocationsTableHelper;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.tools.gui.qNIK;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

class SSLProxyingPanel
extends SettingsPanel {
    private final qNIK modePanel;
    private final LocationsTableHelper locations;
    private final LocationsTableHelper exclude;

    public SSLProxyingPanel() {
        super(CharlesContext.getInstance().getBundle().getString("settings.proxy.ssl.name"));
        SSLProxyingPanel sSLProxyingPanel = this;
        sSLProxyingPanel.setHelp(sSLProxyingPanel.ctx.getBundle().getString("settings.proxy.ssl.help"));
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        this.modePanel = new qNIK("SSL Proxying", 1);
        this.locations = new LocationsTableHelper(proxyConfiguration.getSSLLocations().getLocationPatterns(), false, false);
        this.exclude = new LocationsTableHelper(proxyConfiguration.getSSLExcludeLocations().getLocationPatterns(), false, false);
        EnableAwareJPanel enableAwareJPanel = new EnableAwareJPanel((LayoutManager)new MigLayout("wrap,fill,ins 0", "[][]", "[][fill,grow]"));
        enableAwareJPanel.add(new JLabel("Include"));
        enableAwareJPanel.add(new JLabel("Exclude"));
        this.locations.FwRs(enableAwareJPanel);
        this.exclude.FwRs(enableAwareJPanel);
        this.modePanel.FwRs(this.locations);
        this.modePanel.FwRs(this.exclude);
        this.modePanel.FwRs(enableAwareJPanel, false);
        this.configure(proxyConfiguration);
        SSLProxyingPanel sSLProxyingPanel2 = this;
        sSLProxyingPanel2.add(FormUtils.InuZ(sSLProxyingPanel2.ctx.getBundle().getString("settings.proxy.ssl.blurb")));
        SSLProxyingPanel sSLProxyingPanel3 = this;
        sSLProxyingPanel3.add(sSLProxyingPanel3.modePanel.FwRs());
        this.add((Component)enableAwareJPanel, "grow, push");
    }

    void configure(ProxyConfiguration proxyConfiguration) {
        this.modePanel.FwRs(proxyConfiguration.isDecryptSSL());
    }

    @Override
    public boolean save() {
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        proxyConfiguration.setDecryptSSL(this.modePanel.GSXJ());
        proxyConfiguration.setSSLLocations(new LocationPatternConfiguration(this.locations.Gwbn().getRows()));
        proxyConfiguration.setSSLExcludeLocations(new LocationPatternConfiguration(this.exclude.Gwbn().getRows()));
        CharlesContext.getInstance().getProxyManager().HliR();
        return true;
    }

    public void updateForm() {
    }
}

