/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.config.GistIntegrationConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJLabel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.GistIntegrationSettingsPanel$2;
import com.xk72.charles.gui.settings.GistIntegrationSettingsPanel$3;
import com.xk72.charles.gui.settings.ImportExportPanel;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.gui.settings.nUdO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class GistIntegrationSettingsPanel
extends SettingsPanel
implements ImportExportPanel<GistIntegrationConfiguration> {
    private static final Logger FwRs = Logger.getLogger("com.xk72.charles.gui.settings.GistIntegrationSettingsPanel");
    private static final URI GSXJ;
    private static final String InuZ = "You have a saved authorisation token for your current GitHub server.  This token will not be valid for other GitHub installations.";
    private static final String Gwbn = "You need to manually generate a personal access token from your enterprise GitHub account. You can then copy and paste that token below to allow Charles to publish gists on your behalf.";
    private final JCheckBox openGist = new JCheckBox("Open Gist after publishing");
    private final JRadioButton secret = new JRadioButton("Secret", true);
    private final JRadioButton pub = new JRadioButton("Public", false);
    private final JTextField publishLimit = new JTextField(7);
    private final JComponent tokenMessage = FormUtils.InuZ("Charles is authorized to publish to your GitHub account.");
    private final JComponent requestTokenMessage = FormUtils.InuZ("You must authorize Charles to publish Gists using your GitHub account. This will open GitHub.com where you can grant Charles access to publish with your account.");
    private final JButton requestToken;
    private final JButton clearToken;
    private final JLabel token = new JLabel();
    private final JCheckBox enterpriseGitHub = new JCheckBox("Use GitHub Enterprise");
    private final JTextField enterpriseURL = new JTextField(20);

    public GistIntegrationSettingsPanel() {
        super("Publish");
        Object object = new JPanel(FormUtils.eOaK());
        JPanel jPanel = new JPanel(FormUtils.GSXJ());
        ((Container)object).add((Component)jPanel, "span, growx");
        FormUtils.FwRs((JPanel)object);
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.secret);
        ((ButtonGroup)serializable).add(this.pub);
        ((Container)object).add(new JLabel("Publish as:"));
        ((Container)object).add((Component)this.secret, "split 2, grow 0");
        ((Container)object).add(this.pub);
        ((Container)object).add(new JLabel("Publish limit (MB):"));
        ((Container)object).add((Component)this.publishLimit, "grow 0");
        ((Container)object).add((Component)this.openGist, "skip");
        ((Container)object).add((Component)this.enterpriseGitHub, "skip");
        this.enterpriseURL.setEnabled(this.enterpriseGitHub.isSelected());
        this.enterpriseGitHub.addItemListener(new nUdO(this));
        ((Container)object).add(new EnableAwareJLabel("GitHub location:", this.enterpriseURL));
        ((Container)object).add(this.enterpriseURL);
        serializable = this.token.getFont();
        serializable = ((Font)serializable).deriveFont(((Font)serializable).getSize2D() - 2.0f);
        this.token.setFont((Font)serializable);
        jPanel.add((Component)this.tokenMessage, "hidemode 3,left,width 500lp!");
        jPanel.add((Component)this.token, "split 2,hidemode 3");
        this.clearToken = new JButton(new GistIntegrationSettingsPanel$2(this, "Remove"));
        jPanel.add((Component)this.clearToken, "hidemode 3, wmin button, growx 0");
        jPanel.add((Component)this.requestTokenMessage, "hidemode 3,left, width 500lp!");
        this.requestToken = new JButton(new GistIntegrationSettingsPanel$3(this, "Authorize", (Font)serializable));
        jPanel.add((Component)this.requestToken, "hidemode 3, grow 0, wmin button");
        this.add((Component)object);
        object = this.ctx.getConfiguration().getGistIntegrationConfiguration();
        this.setImportedConfiguration((GistIntegrationConfiguration)object);
    }

    private void FwRs(String object) {
        if (object == null || ((String)object).isEmpty()) {
            this.GSXJ();
            return;
        }
        this.token.setText((String)object);
        this.tokenMessage.setVisible(true);
        this.token.setVisible(true);
        this.clearToken.setVisible(true);
        this.requestTokenMessage.setVisible(false);
        this.requestToken.setVisible(false);
        this.revalidate();
        object = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
        if (object != null) {
            ((Window)object).pack();
        }
    }

    private void GSXJ() {
        this.token.setText("");
        this.tokenMessage.setVisible(false);
        this.token.setVisible(false);
        this.clearToken.setVisible(false);
        this.requestTokenMessage.setVisible(true);
        this.requestToken.setVisible(true);
        this.revalidate();
        Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
        if (dialog != null) {
            dialog.pack();
        }
    }

    @Override
    public GistIntegrationConfiguration getExportConfiguration() {
        GistIntegrationConfiguration gistIntegrationConfiguration = new GistIntegrationConfiguration();
        this.FwRs(gistIntegrationConfiguration);
        return gistIntegrationConfiguration;
    }

    @Override
    public void setImportedConfiguration(GistIntegrationConfiguration gistIntegrationConfiguration) {
        this.openGist.setSelected(gistIntegrationConfiguration.isOpenGist());
        if (gistIntegrationConfiguration.isSecret()) {
            this.secret.setSelected(true);
        } else {
            this.pub.setSelected(true);
        }
        this.publishLimit.setText(String.valueOf(gistIntegrationConfiguration.getPublishLimit()));
        this.FwRs(GistIntegrationSettingsPanel.GSXJ(gistIntegrationConfiguration.getAuthToken()));
        this.enterpriseGitHub.setSelected(gistIntegrationConfiguration.isEnterpriseGitHub());
        this.enterpriseURL.setText(GistIntegrationSettingsPanel.GSXJ(gistIntegrationConfiguration.getEnterpriseURL()));
    }

    @Override
    public boolean preSave() {
        int n = this.prefToInt("Publish Limit", this.publishLimit.getText());
        if (n < 0) {
            throw new SettingsException("Publish Limit", "Please enter a non-negative number.");
        }
        if (this.enterpriseGitHub.isSelected()) {
            Object object = GistIntegrationSettingsPanel.InuZ(this.enterpriseURL.getText());
            if (object == null) {
                throw new SettingsException("GitHub Location", "Please enter a location for your installation e.g. https://api.github.com");
            }
            try {
                object = GistIntegrationConfiguration.parseURL((String)object);
                String string = ((URI)object).getPath();
                if (string != null && !string.equals("/") && string.length() > 0) {
                    throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
                }
                string = ((URI)object).getQuery();
                if (string != null && string.length() > 0) {
                    throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
                }
                if ((object = ((URI)object).getFragment()) != null && ((String)object).length() > 0) {
                    throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                FwRs.log(Level.WARNING, "Error parsing URI: " + uRISyntaxException.getMessage(), uRISyntaxException);
                throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
            }
        }
        return super.preSave();
    }

    public void saveAuth() {
        GistIntegrationConfiguration gistIntegrationConfiguration = this.ctx.getConfiguration().getGistIntegrationConfiguration();
        gistIntegrationConfiguration.setAuthToken(GistIntegrationSettingsPanel.InuZ(this.token.getText()));
        this.ctx.saveConfig();
    }

    @Override
    public boolean save() {
        GistIntegrationConfiguration gistIntegrationConfiguration = this.ctx.getConfiguration().getGistIntegrationConfiguration();
        this.FwRs(gistIntegrationConfiguration);
        return true;
    }

    private void FwRs(GistIntegrationConfiguration gistIntegrationConfiguration) {
        gistIntegrationConfiguration.setOpenGist(this.openGist.isSelected());
        gistIntegrationConfiguration.setSecret(this.secret.isSelected());
        GistIntegrationSettingsPanel gistIntegrationSettingsPanel = this;
        gistIntegrationConfiguration.setPublishLimit(gistIntegrationSettingsPanel.prefToIntSafe(gistIntegrationSettingsPanel.publishLimit.getText()));
        gistIntegrationConfiguration.setAuthToken(GistIntegrationSettingsPanel.InuZ(this.token.getText()));
        gistIntegrationConfiguration.setEnterpriseGitHub(this.enterpriseGitHub.isSelected());
        gistIntegrationConfiguration.setEnterpriseURL(GistIntegrationSettingsPanel.InuZ(this.enterpriseURL.getText()));
    }

    private static String GSXJ(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String InuZ(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    static /* synthetic */ JTextField FwRs(GistIntegrationSettingsPanel gistIntegrationSettingsPanel) {
        return gistIntegrationSettingsPanel.enterpriseURL;
    }

    static /* synthetic */ JLabel GSXJ(GistIntegrationSettingsPanel gistIntegrationSettingsPanel) {
        return gistIntegrationSettingsPanel.token;
    }

    static /* synthetic */ void InuZ(GistIntegrationSettingsPanel gistIntegrationSettingsPanel) {
        gistIntegrationSettingsPanel.GSXJ();
    }

    static /* synthetic */ JCheckBox Gwbn(GistIntegrationSettingsPanel gistIntegrationSettingsPanel) {
        return gistIntegrationSettingsPanel.enterpriseGitHub;
    }

    static /* synthetic */ URI FwRs() {
        return GSXJ;
    }

    static /* synthetic */ void FwRs(GistIntegrationSettingsPanel gistIntegrationSettingsPanel, String string) {
        gistIntegrationSettingsPanel.FwRs(string);
    }

    static {
        try {
            GSXJ = new URI("http://www.charlesproxy.com/github/auth.do");
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }
}

