/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.lib;

import com.xk72.charles.gui.lib.HhLQ;
import com.xk72.charles.gui.lib.KoLr;
import com.xk72.charles.gui.lib.TableMap;
import com.xk72.charles.gui.lib.uILc;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.EventListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class TableSorter
extends TableMap {
    private static final Logger FwRs = Logger.getLogger("com.xk72.charles.gui.lib.TableSorter");
    private int[] indexes;
    private final Vector<Integer> sortingColumns = new Vector();
    private boolean ascending = true;
    private int compares;

    public TableSorter() {
        this.indexes = new int[0];
    }

    public TableSorter(TableModel tableModel) {
        this.setModel(tableModel);
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4 = this.model;
        if (object4 instanceof KoLr) {
            object3 = ((KoLr)object4).getComparableValueAt(n, n3);
            object2 = ((KoLr)object4).getComparableValueAt(n2, n3);
            object = ((KoLr)object4).getComparableColumnClass(n3);
        } else {
            object3 = object4.getValueAt(n, n3);
            object2 = object4.getValueAt(n2, n3);
            object = object4.getColumnClass(n3);
        }
        if (object3 == null && object2 == null) {
            return 0;
        }
        if (object3 == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (((Class)object).getSuperclass() == Number.class) {
            double d;
            object = (Number)object3;
            double d2 = ((Number)object).doubleValue();
            if (d2 < (d = ((Number)(object = (Number)object2)).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (object == Date.class) {
            long l;
            object = (Date)object3;
            long l2 = ((Date)object).getTime();
            if (l2 < (l = ((Date)(object = (Date)object2)).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (object == String.class) {
            object = (String)object3;
            String string2 = (String)object2;
            object4 = string2;
            Object object5 = object;
            object2 = this;
            object2 = TableSorter.FwRs((String)object5);
            int n4 = object2 != null && (object5 = TableSorter.FwRs((String)object4)) != null ? ((Double)object2).compareTo((Double)object5) : 0;
            if (n4 == 0) {
                n4 = ((String)object).compareTo(string2);
            }
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        if (object == Boolean.class) {
            Boolean bl;
            boolean bl2;
            object = (Boolean)object3;
            boolean bl3 = (Boolean)object;
            if (bl3 == (bl2 = (bl = (Boolean)object2).booleanValue())) {
                return 0;
            }
            if (bl3) {
                return 1;
            }
            return -1;
        }
        object = object3.toString();
        int n5 = ((String)object).compareTo(string = object2.toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    private int FwRs(String object, String object2) {
        if ((object = TableSorter.FwRs((String)object)) != null && (object2 = TableSorter.FwRs((String)object2)) != null) {
            return ((Double)object).compareTo((Double)object2);
        }
        return 0;
    }

    private static Double FwRs(String string) {
        int n = string.length();
        while (n > 0) {
            try {
                return Double.parseDouble(string.substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                --n;
            }
        }
        return null;
    }

    public int compare(int n, int n2) {
        ++this.compares;
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Integer n3 = this.sortingColumns.elementAt(i);
            int n4 = this.compareRowsByColumn(n, n2, n3);
            if (n4 == 0) continue;
            if (this.ascending) {
                return n4;
            }
            return -n4;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int n = this.model.getRowCount();
        this.indexes = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            this.indexes[n3] = n3;
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (FwRs.isLoggable(Level.FINER)) {
            FwRs.finer("Sorter: tableChanged");
        }
        this.reallocateIndexes();
        super.tableChanged(tableModelEvent);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount() && FwRs.isLoggable(Level.WARNING)) {
            FwRs.warning("Sorter not informed of a change in model.");
        }
    }

    public void sort(Object object) {
        this.checkModel();
        this.compares = 0;
        int n = this.indexes.length;
        if (this.model instanceof HhLQ) {
            n -= ((HhLQ)this.model).getFooterRows();
        }
        TableSorter tableSorter = this;
        tableSorter.shuttlesort((int[])tableSorter.indexes.clone(), this.indexes, 0, n);
        if (FwRs.isLoggable(Level.FINER)) {
            FwRs.finer("Compares: " + this.compares);
        }
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                TableSorter tableSorter = this;
                if (tableSorter.compare(tableSorter.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            while (n < n2) {
                nArray2[n] = nArray[n];
                ++n;
            }
            return;
        }
        while (n < n2) {
            nArray2[n] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
            ++n;
        }
    }

    public void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n < 0) {
            return null;
        }
        this.checkModel();
        if (n < this.indexes.length) {
            return this.model.getValueAt(this.indexes[n], n2);
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        if (n < this.indexes.length) {
            this.model.setValueAt(object, this.indexes[n], n2);
        }
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, true);
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(n);
        TableSorter tableSorter = this;
        tableSorter.sort(tableSorter);
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable jComponent) {
        EventListener eventListener = this;
        jComponent.setColumnSelectionAllowed(false);
        eventListener = new uILc(this, (JTable)jComponent, (TableSorter)eventListener);
        jComponent = jComponent.getTableHeader();
        jComponent.addMouseListener((MouseListener)eventListener);
    }
}

