/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.lib;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ImagePanel
extends JPanel {
    private Image image;
    private final Font font;

    public ImagePanel() {
        this.setBackground(Color.white);
        this.font = UIManager.getDefaults().getFont("Label.font");
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.image != null) {
            graphics.setFont(this.font);
            int n = this.image.getWidth(null);
            int n2 = this.image.getHeight(null);
            if (n >= 0 && n2 >= 0) {
                graphics.drawString(n + " x " + n2, 0, this.font.getSize() + 3);
            }
            graphics.drawImage(this.image, 0, this.font.getSize() + 10, this);
        }
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public void setImage(byte[] byArray) {
        this.image = Toolkit.getDefaultToolkit().createImage(byArray);
        this.repaint();
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public void clearImage() {
        this.image = null;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(null), this.image.getHeight(null) + this.font.getSize() + 10);
        }
        return super.getPreferredSize();
    }
}

