/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.lib;

import com.xk72.charles.gui.lib.GwTP;
import com.xk72.charles.gui.lib.oVPf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractRowsTableModel<T>
extends AbstractTableModel
implements GwTP<T>,
oVPf {
    protected boolean dirty;
    protected List<T> rows;

    public AbstractRowsTableModel() {
        this(new ArrayList());
    }

    public AbstractRowsTableModel(List<T> list) {
        this.rows = list;
    }

    @Override
    public final int getRowCount() {
        return this.rows.size();
    }

    @Override
    public abstract T newRow();

    @Override
    public int addRow(T t) {
        this.rows.add(t);
        this.setDirty();
        AbstractRowsTableModel abstractRowsTableModel = this;
        abstractRowsTableModel.fireTableRowsInserted(abstractRowsTableModel.rows.size() - 1, this.rows.size() - 1);
        return this.rows.size() - 1;
    }

    @Override
    public boolean isRemovable(int n) {
        return true;
    }

    @Override
    public final void removeRows(int[] nArray, int[] nArray2) {
        Arrays.sort(nArray2);
        for (int i = nArray2.length - 1; i >= 0; --i) {
            int n = nArray2[i];
            if (n < 0 || n >= this.rows.size()) continue;
            this.removeRow(n);
        }
    }

    public void removeRow(int n) {
        this.rows.remove(n);
        this.setDirty();
        int n2 = n;
        this.fireTableRowsDeleted(n2, n2);
    }

    @Override
    public final List<T> getRows() {
        return this.rows;
    }

    @Override
    public final void setRows(List<T> list) {
        this.rows = list;
        this.setDirty();
        this.fireTableDataChanged();
    }

    @Override
    public final T getRowAt(int n) {
        if (n < this.rows.size()) {
            return this.rows.get(n);
        }
        return null;
    }

    @Override
    public void setRowAt(int n, T t) {
        if (n < this.rows.size()) {
            this.rows.set(n, t);
            this.setDirty();
            int n2 = n;
            this.fireTableRowsUpdated(n2, n2);
        }
    }

    @Override
    public int[] moveRows(int[] nArray, int n) {
        Arrays.sort(nArray);
        if (n < 0) {
            int n2;
            int n3;
            for (int i = 0; i < nArray.length && (n3 = Math.max((n2 = nArray[i]) + n, 0)) != n2; ++i) {
                List<T> list = this.rows;
                list.add(n3, list.remove(n2));
                nArray[i] = n3;
            }
        } else {
            int n4;
            int n5;
            for (int i = nArray.length - 1; i >= 0 && (n5 = Math.min((n4 = nArray[i]) + n, this.rows.size() - 1)) != n4; --i) {
                List<T> list = this.rows;
                list.add(n5, list.remove(n4));
                nArray[i] = n5;
            }
        }
        this.setDirty();
        this.fireTableDataChanged();
        return nArray;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public void setDirty() {
        this.setDirty(true);
    }
}

